<?php
session_start();
if(isset($_SESSION['user'])) {
    header('Location: dashboard.php');
    exit;
}
$message = '';
if($_SERVER['REQUEST_METHOD'] === 'POST') {
    require 'db.php';
    $email = $_POST['email'] ?? '';
    $password = $_POST['password'] ?? '';
    $stmt = $pdo->prepare('SELECT * FROM users WHERE email = ? LIMIT 1');
    $stmt->execute([$email]);
    $user = $stmt->fetch();
    if($user && password_verify($password, $user['password'])) {
        $_SESSION['user'] = ['id'=>$user['id'],'name'=>$user['name'],'role'=>$user['role'],'group_id'=>$user['group_id']];
        header('Location: dashboard.php');
        exit;
    } else {
        $message = 'Login gagal: cek email atau password.';
    }
}
?>
<!doctype html>
<html>
<head><meta charset="utf-8"><title>Login - Misa Manager</title></head>
<body>
<h2>Masuk - Misa Manager</h2>
<?php if($message): ?><p style="color:red;"><?php echo htmlspecialchars($message); ?></p><?php endif; ?>
<form method="post">
  Email:<br><input name="email" type="email" required><br>
  Password:<br><input name="password" type="password" required><br><br>
  <button type="submit">Login</button>
</form>
</body>
</html>
