<?php
session_start();
if(!isset($_SESSION['user'])) { header('Location: index.php'); exit; }
require 'db.php';
if($_SERVER['REQUEST_METHOD']==='POST') {
    $schedule_id = intval($_POST['schedule_id']);
    $user_id = $_SESSION['user']['id'];
    // default remind 12 hours before
    $stmt = $pdo->prepare('SELECT ms_date, ms_time FROM schedule WHERE id = ? LIMIT 1');
    $stmt->execute([$schedule_id]);
    $s = $stmt->fetch();
    if($s) {
        $dt = new DateTime($s['ms_date'].' '.$s['ms_time']);
        $dt->modify('-12 hours');
        $remind_at = $dt->format('Y-m-d H:i:s');
        $stmt2 = $pdo->prepare('INSERT INTO reminders (schedule_id, user_id, remind_at) VALUES (?,?,?)');
        $stmt2->execute([$schedule_id, $user_id, $remind_at]);
    }
}
header('Location: dashboard.php');
exit;
?>