<?php
session_start();
error_reporting(E_ALL);
ini_set('display_errors', 1);
ini_set("memory_limit", "512M");

if (!isset($_SESSION["login"])) {
    header("Location: login.php");
    exit;
}

require 'vendor/autoload.php';
require 'functions.php';

use Mpdf\Mpdf;

function terbilang($angka)
{
    $angka = abs($angka);
    $bilangan = ["", "satu", "dua", "tiga", "empat", "lima", "enam", "tujuh", "delapan", "sembilan", "sepuluh", "sebelas"];
    $hasil = "";

    if ($angka < 12) {
        $hasil = $bilangan[$angka];
    } elseif ($angka < 20) {
        $hasil = $bilangan[$angka - 10] . " belas";
    } elseif ($angka < 100) {
        $hasil = terbilang(intval($angka / 10)) . " puluh " . terbilang($angka % 10);
    } elseif ($angka < 200) {
        $hasil = "seratus " . terbilang($angka - 100);
    } elseif ($angka < 1000) {
        $hasil = terbilang(intval($angka / 100)) . " ratus " . terbilang($angka % 100);
    } elseif ($angka < 2000) {
        $hasil = "seribu " . terbilang($angka - 1000);
    } elseif ($angka < 1000000) {
        $hasil = terbilang(intval($angka / 1000)) . " ribu " . terbilang($angka % 1000);
    } elseif ($angka < 1000000000) {
        $hasil = terbilang(intval($angka / 1000000)) . " juta " . terbilang($angka % 1000000);
    }

    return ucwords(trim(preg_replace('/\s+/', ' ', $hasil)));
}

$id = $_GET["id"];
$data = query("SELECT * FROM data_student WHERE id = $id")[0];

$nama = $data['nama'];
$alamat = $data['alamat'];
$terima_uang = $data['terima_uang'];
$wawa = $data['wawa'];
$tanggal_hari_ini = date('d-m-Y');
$terbilang_uang = terbilang($terima_uang);

function generateTableRow($label, $value) {
    return "<tr><td style='width:150px;'>$label</td><td style='width:10px;'>:</td><td><strong>$value</strong></td></tr>";
}

if (isset($_GET['download'])) {
    try {
        $mpdf = new Mpdf();

        $html = '
        <div style="position: relative; width:20cm; height:10cm; border:2px solid #000; padding:20px; font-family:Arial, sans-serif;">
            <div style="position:absolute; top:50%; left:50%; transform:translate(-50%,-50%); font-size:60px; color:#cccccc; opacity:0.2; z-index:0;">
                SINAR TERANG
            </div>

            <img src="https://mar-sin.xyz/karyawan/sinar_terang.jpeg" style="position:absolute; top:20px; right:20px; width:100px; z-index:1;">
            
            <div style="margin-top:100px; font-size:18px; position:relative; z-index:2;">
                <table cellspacing="5" cellpadding="2">' .
                    generateTableRow("Nama", htmlspecialchars($nama)) .
                    generateTableRow("Alamat", htmlspecialchars($alamat)) .
                    generateTableRow("No. WA", htmlspecialchars($wawa)) .
                    generateTableRow("U. Jajan Sebulan", "Rp. " . number_format($terima_uang, 0, ',', '.')) .
                    generateTableRow("Terbilang", "<em>$terbilang_uang</em>") .
                '</table>
                <p style="margin-top:10px;">Jakarta, ' . $tanggal_hari_ini . '</p>
            </div>
        </div>';

        $mpdf->WriteHTML($html);
        $mpdf->Output('slip_uangjajan_'.$nama.'.pdf', 'D');
        exit;
    } catch (\Mpdf\MpdfException $e) {
        echo "Error PDF: " . $e->getMessage();
    }
}
?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <title>Slip Uang Jajan</title>
    <style>
        .slip {
            width: 20cm;
            height: 10cm;
            border: 2px solid #000;
            padding: 20px;
            position: relative;
            font-family: Arial, sans-serif;
        }
        .logo {
            position: absolute;
            top: 20px;
            right: 20px;
            width: 100px;
        }
        .isi-slip {
            margin-top: 100px;
            font-size: 18px;
            position: relative;
            z-index: 2;
        }
        .watermark {
            position: absolute;
            top: 50%;
            left: 50%;
            transform: translate(-50%, -50%);
            font-size: 60px;
            color: #cccccc;
            opacity: 0.2;
            z-index: 0;
            pointer-events: none;
        }
        .tombol {
            margin-top: 20px;
        }
        .tombol button {
            padding: 10px 20px;
            font-size: 16px;
            margin-right: 10px;
            cursor: pointer;
        }
        table {
            border-collapse: collapse;
        }
        td {
            vertical-align: top;
        }
    </style>
</head>
<body>

<div class="slip" id="slip">
    <div class="watermark">SINAR TERANG</div>
    <img src="https://mar-sin.xyz/karyawan/sinar_terang.jpeg" class="logo" alt="Logo">
    <div class="isi-slip">
        <table cellspacing="5" cellpadding="2">
            <?= generateTableRow("Nama", htmlspecialchars($nama)) ?>
            <?= generateTableRow("Alamat", htmlspecialchars($alamat)) ?>
            <?= generateTableRow("No. WA", htmlspecialchars($wawa)) ?>
            <?= generateTableRow("U. Jajan Sebulan", "Rp. " . number_format($terima_uang, 0, ',', '.')) ?>
            <?= generateTableRow("Terbilang", "<em>$terbilang_uang Rupiah</em>") ?>
        </table>
        <p style="margin-top:10px;">Jakarta, <?= $tanggal_hari_ini ?></p>
    </div>
</div>

<div class="tombol">
    <button onclick="window.print()">A. Cetak ke Printer</button>
    <a href="?id=<?= $id ?>&download=1"><button type="button">B. Download PDF</button></a>
</div>

<script>
    window.addEventListener('DOMContentLoaded', () => {
        const nama = <?= json_encode($nama) ?>;
        const alamat = <?= json_encode($alamat) ?>;
        
        const terbilang = <?= json_encode($terbilang_uang) ?>;
        const kalimat = `Uang jajan adik ${nama} dari ${alamat} sebulan sebesar ${terbilang} rupiah`;

        const msg = new SpeechSynthesisUtterance(kalimat);
        msg.lang = 'id-ID';
        msg.rate = 0.9;
        speechSynthesis.speak(msg);
    });
</script>

</body>
</html>
