<?php



$conn = mysqli_connect("localhost", "jbkzbmma", 'o7B-a54CP7fp#G', "jbkzbmma_student");


if (!$conn) {
    die("Koneksi gagal: " . mysqli_connect_error());
}

// Ambil data jumlah siswa berdasarkan jenis kelamin
$query = mysqli_query($conn, "SELECT jk, COUNT(*) as jumlah FROM data_student GROUP BY jk");

$labels = [];
$data = [];

while ($row = mysqli_fetch_assoc($query)) {
    $labels[] = ucfirst($row['jk']); // Kapitalisasi awal
    $data[] = $row['jumlah'];
}

$total_students = array_sum($data); // Total jumlah siswa
?>
<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1"> <!-- Penting untuk mobile -->
    <title>Diagram Venn Jumlah Student</title>
    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
    <style>
        body {
            font-family: Arial, sans-serif;
            text-align: center;
            margin: 0;
            padding: 10px;
            background-color: #f0f0f0;
            font-size: 14px;
        }

        h2 {
            margin: 10px 0 5px;
            font-size: 16px;
        }

        p {
            margin: 5px 0 15px;
            font-size: 13px;
        }

        .container {
            width: 100%;
            max-width: 280px;
            margin: 0 auto;
        }

        canvas {
            width: 100% !important;
            height: auto !important;
        }
    </style>
</head>
<body>

<h2>Diagram Venn Jumlah Student</h2>
<p>Jumlah Student: <?php echo $total_students; ?> orang</p>

<div class="container">
    <canvas id="vennChart"></canvas>
</div>

<script>
    const labels = <?php echo json_encode($labels); ?>;
    const data = <?php echo json_encode($data); ?>.map(Number);
    const total = data.reduce((a, b) => a + b, 0);

    const ctx = document.getElementById("vennChart").getContext("2d");
    const vennChart = new Chart(ctx, {
        type: 'pie',
        data: {
            labels: labels,
            datasets: [{
                data: data,
                backgroundColor: [
                    "rgba(54, 162, 235, 0.7)",   // Pria
                    "rgba(255, 99, 132, 0.7)"    // Wanita
                ],
                borderColor: [
                    "rgba(54, 162, 235, 1)",
                    "rgba(255, 99, 132, 1)"
                ],
                borderWidth: 1.5,
                radius: '100%' // Ubah radius agar pas di layar kecil
            }]
        },
        options: {
            responsive: true,
            maintainAspectRatio: false,
            plugins: {
                legend: {
                    position: 'bottom',
                    labels: {
                        boxWidth: 10,
                        font: {
                            size: 12
                        }
                    }
                },
                tooltip: {
                    callbacks: {
                        label: function(context) {
                            let val = context.raw;
                            let percent = ((val / total) * 100).toFixed(1);
                            return `${context.label}: ${val} siswa (${percent}%)`;
                        }
                    }
                }
            }
        }
    });
</script>

</body>
</html>
