<?php
require 'functions.php';

session_start();
if (!isset($_SESSION["login"])) {
    header("Location: login.php");
    exit;
}

$logkanwil = $_SESSION["logkanwil"];

if (isset($_SESSION["login"]) && ($_SESSION["logkanwil"] != "KP")) {
    header("Location: index.php");
    exit;
}

// Ambil jumlah siswa berdasarkan jenis kelamin
$query = mysqli_query($conn, "SELECT jk, COUNT(*) as jumlah FROM data_student GROUP BY jk");

$labels = [];
$data = [];

while ($row = mysqli_fetch_assoc($query)) {
    $labels[] = ucfirst($row['jk']);
    $data[] = $row['jumlah'];
}

$jumlah = array_sum($data);
?>

<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <title>Grafik Bar Jumlah Student</title>
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
    <style>
        body {
            font-family: Arial, sans-serif;
            text-align: center;
            margin: 0;
            padding: 10px;
            background-color: #f9f9f9;
        }

        h2 {
            font-size: 18px;
            color: red;
            margin-bottom: 5px;
        }

        .jumlah {
            font-size: 14px;
            margin-bottom: 10px;
        }

        .chart-container {
            width: 100%;
            max-width: 320px;
            margin: 0 auto;
        }

        canvas {
            width: 100% !important;
            height: auto !important;
        }
    </style>
</head>
<body>

<h2>Grafik Bar Jumlah Student</h2>
<div class="jumlah">Jumlah Student: <?php echo $jumlah; ?> orang</div>

<div class="chart-container">
    <canvas id="myChart"></canvas>
</div>

<script>
    const ctx = document.getElementById("myChart").getContext('2d');
    const myChart = new Chart(ctx, {
        type: 'bar',
        data: {
            labels: <?php echo json_encode($labels); ?>,
            datasets: [{
                label: 'Jumlah Siswa',
                data: <?php echo json_encode($data); ?>,
                backgroundColor: [
                    'rgba(75, 192, 192, 0.5)',
                    'rgba(255, 99, 132, 0.5)'
                ],
                borderColor: [
                    'rgba(75, 192, 192, 1)',
                    'rgba(255, 99, 132, 1)'
                ],
                borderWidth: 1
            }]
        },
        options: {
            responsive: true,
            maintainAspectRatio: false,
            scales: {
                y: {
                    beginAtZero: true,
                    ticks: {
                        precision: 0,
                        font: {
                            size: 10
                        }
                    }
                },
                x: {
                    ticks: {
                        font: {
                            size: 10
                        }
                    }
                }
            },
            plugins: {
                legend: {
                    labels: {
                        font: {
                            size: 10
                        }
                    }
                }
            }
        }
    });
</script>

</body>
</html>
