<?php 
date_default_timezone_set('Asia/Jakarta');
session_start();
$logkanwil = $_SESSION["logkanwil"];

if (!isset($_SESSION["login"])) {
    header("Location: login.php");
    exit;
}

require 'functions.php';
?>

<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <title>Tambah Ramalan AI</title>
    <link rel="shortcut icon" href="idea.png">
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/4.3.1/css/bootstrap.min.css">
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.4.1/jquery.min.js"></script>
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <style>
        body {
            font-family: Arial, sans-serif;
            padding: 10px;
        }
        h1 {
            font-size: 20px;
            text-align: center;
        }
        form {
            max-width: 800px;
            margin: auto;
            background: #f9f9f9;
            padding: 15px;
            border-radius: 8px;
            box-shadow: 0 0 15px 5px rgba(0,0,0,0.1);
        }
        table {
            width: 100%;
        }
        td {
            padding: 6px;
            vertical-align: middle;
        }
        input[type="text"] {
            width: 600px;
            padding: 6px;
            font-size: 14px;
        }
        button {
            width: 100%;
            padding: 10px;
            font-size: 14px;
        }
        @media screen and (max-width: 380px) {
            h1 {
                font-size: 18px;
            }
            input[type="text"], button {
                width: 100% !important;
                font-size: 12px;
                padding: 6px;
            }
        }
    </style>
</head>
<body>

<div class="mb-2 text-center">
    <span>USER: <?= $logkanwil ?></span>
    <br>
    <a href="logout.php">Logout</a> | 
    <a href="index.php">Home</a>
</div>

<h1>Tambah Ramalan AI</h1>

<form id="formData" enctype="multipart/form-data">
    <table>
        <tr>
            <td><label for="nilai">Ramalan AI:</label></td>
            <td><input type="text" name="nilai" id="nilai" required maxlength="50"  autofocus></td>
        </tr>
        <tr>
            <td colspan="2">
                <button class="btn btn-danger" type="submit">Konfirmasi</button>
            </td>
        </tr>
    </table>
</form>

<script>


document.getElementById("formData").addEventListener("submit", function(e) {
    e.preventDefault();

    const nilai = document.getElementById("nilai").value;

    const konfirmasi = confirm(`Konfirmasi Ramalan:\n${nilai}\n\nLanjutkan?`);
    if (konfirmasi) {
        const form = new FormData();
        form.append("nilai", nilai);
        form.append("simpan", "1");

        fetch("tambah_ramalan_ai.php", {
            method: "POST",
            body: form
        }).then(response => response.text())
          .then(result => {
            document.open();
            document.write(result);
            document.close();
        });
    } else {
        // Jika user membatalkan, kembalikan fokus ke field input
        document.getElementById("nilai").focus();
    }
});




</script>

<?php
if (isset($_POST["simpan"])) {
    if (tambah_ramalan_ai($_POST) > 0) {
        echo "<script>
            alert('Data berhasil ditambahkan!');
            window.location.href = 'tabel_ramalan_ai.php';
        </script>";
    } else {
        echo "<script>
            alert('Data gagal ditambahkan!');
            window.location.href = 'tambah_ramalan_ai.php';
        </script>";
    }
}
?>

</body>
</html>
