<?php
// Koneksi database
$conn = new mysqli("localhost", "u1665228", "niaga1234", "u1665228_student");
if ($conn->connect_error) {
    die("Koneksi gagal: " . $conn->connect_error);
}

// Pagination
$perPage = 20;
$page = isset($_GET['page']) ? (int) $_GET['page'] : 1;
if ($page < 1) $page = 1;

$offset = ($page - 1) * $perPage;

// Hitung total data
$totalQuery = $conn->query("SELECT COUNT(*) as total FROM data_foto_keren");
$totalRow = $totalQuery->fetch_assoc();
$totalData = $totalRow['total'];
$totalPages = ceil($totalData / $perPage);

// Ambil data halaman saat ini
$sql = "SELECT * FROM data_foto_keren ORDER BY waktu_upload DESC LIMIT $perPage OFFSET $offset";
$result = $conn->query($sql);
?>

<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <title>Galeri Foto Keren</title>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@4.6.2/dist/css/bootstrap.min.css">
    <style>
        img {
            max-width: 100px;
            height: auto;
            border-radius: 8px;
            cursor: pointer;
            transition: transform 0.3s ease;
        }
        .zoom-img {
            max-width: 90vw;
            max-height: 90vh;
            position: fixed;
            top: 50%;
            left: 50%;
            transform: translate(-50%, -50%) scale(0) rotate(0deg);
            z-index: 1001;
            border: 4px solid white;
            box-shadow: 0 0 10px rgba(0,0,0,0.8);
            animation: zoomSpin 0.8s forwards ease-in-out;
        }
        @keyframes zoomSpin {
            0% { transform: translate(-50%, -50%) scale(0) rotate(0deg); }
            50% { transform: translate(-50%, -50%) scale(1.1) rotate(360deg); }
            100% { transform: translate(-50%, -50%) scale(1) rotate(720deg); }
        }
        .overlay {
            position: fixed;
            top: 0; left: 0;
            width: 100%; height: 100%;
            background-color: rgba(0,0,0,0.7);
            z-index: 1000;
        }
    </style>
</head>
<body class="container my-4">
    <h2 class="text-center mb-4">Galeri Foto Keren</h2>
    <table class="table table-bordered table-hover table-sm">
        <thead class="thead-dark">
            <tr>
                <th>No.</th>
                <th>Action</th>
                
                <th>Nama</th>
                <th>Kelas</th>
                <th>No. WA</th>
                <th>Foto</th>
                <th>Lokasi Foto</th>
                <th>Deskripsi</th>
                <th>Waktu Upload</th>
            </tr>
        </thead>
        <tbody>
            <?php if ($result->num_rows > 0): ?>
                <?php $no = $offset + 1; while($row = $result->fetch_assoc()): ?>
                    <tr>
                        <td><?= $no++; ?></td>
                         <td>
                            <a href="ubahfoto.php?id=<?= $row["id"]; ?>" class="btn btn-warning btn-sm">Ubah</a>
                            <a href="hapusfoto.php?id=<?= $row["id"]; ?>" class="btn btn-danger btn-sm" onclick="return confirm('Yakin ingin menghapus data <?= htmlspecialchars($row["nama"]); ?>?')">Hapus</a>
                    </td>
                    
                        <td><?= htmlspecialchars($row['nama']); ?></td>
                        <td><?= htmlspecialchars($row['kelas']); ?></td>
                        <td><?= htmlspecialchars($row['wawa']); ?></td>
                        <td>
                            <?php if (!empty($row["foto"])): ?>
                                <img src="uploads/<?= htmlspecialchars($row["foto"]) ?>" alt="foto" onclick="zoomImage(this)">
                            <?php else: ?>
                                <span class="text-muted">(Tidak ada)</span>
                            <?php endif; ?>
                        </td>
                        <td><?= htmlspecialchars($row['foto_dimana']); ?></td>
                        <td><?= htmlspecialchars($row['deskripsi']); ?></td>
                        <td><?= date('d-m-Y H:i:s', strtotime($row['waktu_upload'])); ?></td>
                    </tr>
                <?php endwhile; ?>
            <?php else: ?>
                <tr><td colspan="8" class="text-center text-muted">Belum ada data foto keren.</td></tr>
            <?php endif; ?>
        </tbody>
    </table>

    <!-- Pagination -->
    <nav aria-label="Navigasi halaman">
        <ul class="pagination justify-content-center">
            <?php if ($page > 1): ?>
                <li class="page-item"><a class="page-link" href="?page=1">« Awal</a></li>
                <li class="page-item"><a class="page-link" href="?page=<?= $page - 1 ?>">‹ Sebelumnya</a></li>
            <?php endif; ?>
            <?php for ($i = 1; $i <= $totalPages; $i++): ?>
                <li class="page-item <?= ($i === $page) ? 'active' : '' ?>">
                    <a class="page-link" href="?page=<?= $i ?>"><?= $i ?></a>
                </li>
            <?php endfor; ?>
            <?php if ($page < $totalPages): ?>
                <li class="page-item"><a class="page-link" href="?page=<?= $page + 1 ?>">Berikutnya ›</a></li>
                <li class="page-item"><a class="page-link" href="?page=<?= $totalPages ?>">Akhir »</a></li>
            <?php endif; ?>
        </ul>
    </nav>

    <script>
    function zoomImage(imgElement) {
        const src = imgElement.src;
        
        
        // Suara kamera
        const audio1 = new Audio('pusing.mp3');
       const audio2 = new Audio('kamera.mp3');

      audio1.play();
      audio1.addEventListener('ended', () => {
            audio2.play();
         });

        const zoomedImg = document.createElement("img");
        zoomedImg.src = src;
        zoomedImg.className = "zoom-img";

        zoomedImg.onclick = () => {
            document.body.removeChild(overlay);
            document.body.removeChild(zoomedImg);
        };

        const overlay = document.createElement("div");
        overlay.className = "overlay";
        overlay.onclick = () => {
            document.body.removeChild(overlay);
            document.body.removeChild(zoomedImg);
        };

        document.body.appendChild(overlay);
        document.body.appendChild(zoomedImg);
    }
    </script>
</body>
</html>

<?php $conn->close(); ?>
